#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

#pragma warning(disable: 4291)

ScriptImpClass *Get_Script(GameObject *obj, int scriptID)
{
	SimpleDynVecClass<GameObjObserverClass *> *observers = &((ScriptableGameObj *)obj)->Observers;
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		if((*observers)[i]->GetID() == scriptID)
		{
			return ((ScriptImpClass*)(*observers)[i]);
		}
	}
	return 0;
}

PyCFunction* scriptsdll_destroyscript(PyObject *self, PyObject *args)
{
	int scriptid, objid;

	if (!PyArg_ParseTuple(args, "ii", &scriptid, &objid))
	{
		printf("\nError occured inside scriptsdll.Destroy_Script.\n Bad argument(s)?\n");
        return NULL;
	}
	ScriptImpClass *script = Get_Script(Commands->Find_Object(objid), scriptid);
	script->Destroy_Script();
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getfloatparameter(PyObject *self, PyObject *args)
{
	int scriptid, objid;
	const char* name;
	float value;

	if (!PyArg_ParseTuple(args, "iis", &scriptid, &objid, &name))
	{
		printf("\nError occured inside scriptsdll.Get_Float_Parameter.\n Bad argument(s)?\n");
		return NULL;
	}
	ScriptImpClass *script = Get_Script(Commands->Find_Object(objid), scriptid);
	value = script->Get_Float_Parameter(name);
	return Py_BuildValue("f", value);
}

PyObject* scriptsdll_getintparameter(PyObject *self, PyObject *args)
{
	int scriptid, objid;
	const char* name;
	int value;

	if (!PyArg_ParseTuple(args, "iis", &scriptid, &objid, &name))
	{
		printf("\nError occured inside scriptsdll.Get_Int_Parameter.\n Bad argument(s)?\n");
		return NULL;
	}
	ScriptImpClass *script = Get_Script(Commands->Find_Object(objid), scriptid);
	value = script->Get_Int_Parameter(name);
	return Py_BuildValue("i", value);
}

PyObject* scriptsdll_getstringparameter(PyObject *self, PyObject *args)
{
	int scriptid, objid;
	const char* name;
	const char* value;

	if (!PyArg_ParseTuple(args, "iis", &scriptid, &objid, &name))
	{
		printf("\nError occured inside scriptsdll.Get_String_Parameter.\n Bad argument(s)?\n");
		return NULL;
	}
	ScriptImpClass *script = Get_Script(Commands->Find_Object(objid), scriptid);
	value = script->Get_Parameter(name);
	return Py_BuildValue("s", value);
}

PyCFunction* scriptsdll_starttimer(PyObject *self, PyObject *args)
{
	int scriptid, objid, number;
	float time;

	if (!PyArg_ParseTuple(args, "iifi", &scriptid, &objid, &time, &number))
	{
		printf("\nError occured inside scriptsdll.Start_Timer.\n Bad argument(s)?\n");
        return NULL;
	}
	ScriptImpClass *script = Get_Script(Commands->Find_Object(objid), scriptid);
	Commands->Start_Timer(Commands->Find_Object(objid), script, time, number);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}